// wiki.js - Wiki route module.

const express = require("express");
const orgs = require("../models/orgs.js");
const db = require("../models/connection.js");
const router = express.Router();


router.post('/createOrg',function(req,res){
	var new_obj = req.body;
  console.log("Recieved Body : ",new_obj)
	var cons = db.connect();
	 orgs.createOrg(new_obj.org_name,new_obj.created_by,cons).then(() => {
            res.status(200).json({"result":"ok","message":"Organisazion Created Successfully"});
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Organisazion Could not be Created"});
       });

});

router.get('/getOrgs/:type/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
   orgs.getOrgs(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});

router.get('/getOrgService/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
   orgs.getOrgsService(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});


router.get('/getOrgServices/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
   orgs.getOrgsService(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});



module.exports = router;