// wiki.js - Wiki route module.

const express = require("express");
const que = require("../models/que.js");
const db = require("../models/connection.js");
const fs = require('fs');
var misc = require('../com.model/misc.js')
const router = express.Router();


router.post('/queUser',function(req,res){
	var new_obj = req.body;
  console.log("Recieved Body : ",new_obj)
	var cons = db.connect();
	 que.createOrg(new_obj.userID,new_obj.orgID,new_obj.services[0],cons).then(() => {
            res.status(200).json({"result":"ok","message":"Qued Created Successfully"});
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Ticket Could not be Created"});
       });

});

router.get('/cancelService/:ticketNumber',function(req,res){
    var para = req.params;
    var con = db.connect();
  console.log("Before Params : ",para);
  que.cancelService(para.ticketNumber,para.que_no,fs,con,misc).then((result)=>{
      res.status(200).json(result);
  }).catch((err)=>{
      res.status(500).json({"result": "fail","message":"Server Error"});
  })
  
});



router.get('/getOrgQue/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
    console.log(bod);
   que.incommingQue(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});



router.get('/requestStatus/:userID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log(bod);
   que.requestStatus(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});



router.get('/getMyQue/:type/:userID/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
   que.getMyQue(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});



router.post('/recieveOnline',function(req,res){
     var bod = req.body;
     var cons = db.connect2();
     console.log(bod);
     //console.log("Service Len : ",bod[2].Services.length)
     var i=0;
     var req_que = [];
     if(bod[0].ID.length == bod[1].Phone.length && bod[2].Services.length == bod[1].Phone.length)
          for(;i<bod[0].ID.length;i++){
               req_que.push({nationalID:bod[0].ID[i],phone:bod[1].Phone[i],services:bod[2].Services[i],req_no:bod[3].Request[i],userID:bod[6].UserID[i],orgID:bod[5].Organization[i]});
               //if((i + 1)==bod[0].)
          }
          console.log("Sent req_que : ",req_que);
     var last = que.latestNumberMutliT(fs,req_que,cons)
     res.status(200).json({result : "ok",last:last});
      
});


router.get('/asignRandoms',function(req,res){
  var cons = db.connect();
   que.asignRandoms(cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});


router.get('/getServiceQue/:service_no/:orgID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
   que.getServiceQue(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive Organisazions"});
       });
   
});


module.exports = router;