// wiki.js - Wiki route module.

const express = require("express");
const operation = require("../models/reports.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();


router.post('/createReport',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.idNumber != null)
   operation.createReport(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"operation Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createReportDetails',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.unit_cost != null)
   operation.createReportDetails(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"operation details Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.get('/getReports/:type/:ID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getReports(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive report"});
       });
});

router.get('/getReportDetails/:rID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getReportDetails(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive report"});
       });
});

router.get('/getRegions',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getRegions(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive report"});
       });
});

router.get('/getCities/:regID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getCities(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive report"});
       });
});

router.get('/getAreas/:cityID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getAreas(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive report"});
       });
});
module.exports = router;